package giantbombtest

import (
	"time"

	"code.justin.tv/web/discovery/backend/backendtest"
	"code.justin.tv/web/discovery/game"
	"code.justin.tv/web/discovery/giantbomb"
	"golang.org/x/net/context"
)

const (
	TestImageKey   = "small"
	TestImageValue = "image"
	TestName       = "mario"
)

var TestGBGame = giantbomb.GBGame{
	Game: game.Game{
		ID:          backendtest.TestID,
		GiantbombID: backendtest.TestGBID,
		Images:      map[string]string{TestImageKey: TestImageValue},
		Name:        TestName,
	},
	Aliases:      []string{"thing"},
	Genres:       []string{"thing2"},
	Themes:       []string{"thing2"},
	Franchises:   []string{"thing2"},
	SimilarGames: []string{"thing2"},
	LastUpdated:  time.Now(),
}

type mockGB struct {
	Game giantbomb.GBGame
}

func (T *mockGB) FetchGame(ctx context.Context, id int) (giantbomb.GBGame, error) {
	if id == TestGBGame.GiantbombID {
		return T.Game, nil
	}
	return giantbomb.GBGame{}, giantbomb.ErrGameNotFound
}

func (T *mockGB) FetchRecentGames(ctx context.Context, offset, limit int) ([]giantbomb.GBGame, error) {
	if offset < 2 && limit > 0 {
		return []giantbomb.GBGame{T.Game}, nil
	}
	return []giantbomb.GBGame{}, nil
}

func NewGBClient() giantbomb.Client {
	return &mockGB{
		Game: TestGBGame,
	}
}
