#!/usr/bin/env bash

HUP_TIME=2
RESTART_TIME=10

cd /etc/service
for x in `ls -d *discovery*`; do
    sudo svc -d $x
    sleep $HUP_TIME
    sudo svstat $x | grep pid
    if [ $? -eq 0 ]; then
        echo "$x failed to HUP; KILLing"
        sudo svc -kd $x
        sleep 1
    fi

    sudo svc -u $x
    sleep $RESTART_TIME

    # Ensure process isn't flapping
    UPTIME=$(sudo svstat $x | sed -e 's/.* \([0-9]*\) seconds/\1/')
    if (( $UPTIME < $RESTART_TIME/2 )); then
        echo "Process failed to remain up" 1>&2
        exit 1
    fi
done
