package streamstest

import (
	"strconv"
	"strings"

	"code.justin.tv/web/discovery/streams"
	"golang.org/x/net/context"
)

type mockJax struct {
	Games []streams.JaxGame
}

var TestIDs = []int{123, 423, 5634}
var TestNonLiveID = 12389

var TestLiveGames = []streams.JaxGame{
	streams.JaxGame{
		ID:       TestIDs[0],
		Channels: 101,
		Viewers:  104,
	},
	streams.JaxGame{
		ID:       TestIDs[1],
		Channels: 45,
		Viewers:  35,
	},
	streams.JaxGame{
		ID:       TestIDs[2],
		Channels: 1,
		Viewers:  0,
	},
}

func (T *mockJax) LiveGames(ctx context.Context) (map[int]streams.JaxGame, error) {
	m := make(map[int]streams.JaxGame)
	for _, g := range TestLiveGames {
		m[g.ID] = g
	}
	return m, nil
}

func (T *mockJax) LiveGameInfo(ctx context.Context, ids string) (map[int]streams.JaxGame, error) {
	m := make(map[int]streams.JaxGame)
	for i, id := range TestIDs {
		if strings.Contains(ids, strconv.Itoa(id)) {
			m[id] = TestLiveGames[i]
		}
	}
	return m, nil
}

// in returns whether an int is in a list of int.
func in(val int, list []int) bool {
	for _, v := range list {
		if val == v {
			return true
		}
	}
	return false
}

func (T *mockJax) TopGames(ctx context.Context, ordering string) ([]streams.JaxGame, error) {
	return TestLiveGames, nil
}

func NewStreamsClient() streams.Client {
	return &mockJax{Games: TestLiveGames}
}
