# Service name used for AWS tagging among other things
variable "name" {}

# DNS safe service name
variable "hostname" {}

# Team email alias
variable "owner" {}

# Project name, usually git repo. ex. dta/create-twitch-service
variable "project" {}

# EC2 Instance Image
variable "ami" {
  default = "ami-dd11f3bd"
}

# EC2 Instance Type
variable "instance_type" {
  default = "c4.large"
}

# Largest a service cluster will grow to
variable "max_size" {
  default = 0
}

# Smallest a service cluster will shrink down to
variable "min_size" {
  default = 0
}

# Number of canary instances
variable "canary_size" {
  default = 0
}

# Service environment
variable "environment" {}

# Fqdn environment
variable "fqdn_env" {}

# Amount of diskspace allocated to the root drive. (GB)
variable "root_volume_size" {
  default = 256
}

# Service role for controlling access to other AWS services
variable "iam_role_name" {
  default = "discovery"
}

# Remote state variables
variable "twitch_subnets_sg" {}
variable "twitch_service_subnets" {}
variable "twitch_service_a" {}
variable "twitch_service_b" {}
variable "twitch_service_c" {}
variable "asg_lambda_arn" {}
