module "discovery" {
  source = "../modules/discovery"
  name = "discovery"
  hostname = "discovery-production"
  owner = "search-and-discovery@twitch.tv"
  project = "web/discovery"
  ami = "ami-dd11f3bd"
  instance_type = "c4.2xlarge"
  max_size = 8
  min_size = 8
  canary_size = 0
  environment = "production"
  fqdn_env = "prod"
  root_volume_size = "256"
  iam_role_name = "discovery-production"

  twitch_subnets_sg = "${terraform_remote_state.twitch_web_aws.output.twitch_subnets_sg}"
  twitch_service_subnets = "${terraform_remote_state.twitch_web_aws.output.service_subnets}"
  twitch_service_a = "${terraform_remote_state.twitch_web_aws.output.service_a}"
  twitch_service_b = "${terraform_remote_state.twitch_web_aws.output.service_b}"
  twitch_service_c = "${terraform_remote_state.twitch_web_aws.output.service_c}"
  asg_lambda_arn = "${terraform_remote_state.prod_asg_lambda.output.asg_lambda_arn}"
}
