resource "aws_sns_topic" "staging_game_addition_or_deletion" {
  name = "discovery_staging_game_addition_or_deletion"
}

resource "aws_sns_topic_policy" "staging_game_addition_or_deletion_policy" {
  arn = "${aws_sns_topic.staging_game_addition_or_deletion.arn}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Id": "staging_game_addition_or_deletion_policy",
  "Statement":[
    {
      "Sid": "PermitTwitchAWSAccounts",
      "Effect": "Allow",
      "Principal": {
        "AWS": "arn:aws:iam::603200399373:root"
      },
      "Action": [
      "SNS:Subscribe",
      "SNS:SetTopicAttributes",
      "SNS:RemovePermission",
      "SNS:Receive",
      "SNS:Publish",
      "SNS:ListSubscriptionsByTopic",
      "SNS:GetTopicAttributes",
      "SNS:DeleteTopic",
      "SNS:AddPermission"
      ],
      "Resource": [
        "${aws_sns_topic.staging_game_addition_or_deletion.arn}"
      ]
    }
  ]
}
EOF
}
