module "discovery" {
  source = "../modules/discovery"
  name = "discovery"
  hostname = "discovery-staging"
  owner = "search-and-discovery@twitch.tv"
  project = "web/discovery"
  ami = "ami-dd11f3bd"
  instance_type = "m3.medium"
  max_size = 1
  min_size = 1
  canary_size = 0
  environment = "staging"
  fqdn_env = "dev"
  root_volume_size = "256"
  iam_role_name = "discovery-staging"

  twitch_subnets_sg = "${terraform_remote_state.twitch_web_dev.output.twitch_subnets_sg}"
  twitch_service_subnets = "${terraform_remote_state.twitch_web_dev.output.service_subnets}"
  twitch_service_a = "${terraform_remote_state.twitch_web_dev.output.service_a}"
  twitch_service_b = "${terraform_remote_state.twitch_web_dev.output.service_b}"
  twitch_service_c = "${terraform_remote_state.twitch_web_dev.output.service_c}"
  asg_lambda_arn = "${terraform_remote_state.dev_asg_lambda.output.asg_lambda_arn}"
}
