Jax
====

[![GoDoc](://godoc.internal.justin.tv/code.justin.tv/web/jax?status.png)](http://godoc.internal.justin.tv/code.justin.tv/web/jax)

Jax searches for streams.

Documentation
-------------
[API](doc/api.md)

[Troubleshooting and Emergencies](doc/playbook.md)

Development
-----------
TODO: Update this cross platform

First, install Go

    brew install go --cross-compile-common

Now set up your $GOPATH

    mkdir $HOME/go
    export GOPATH=$HOME/go (put it in your profile!)

Download the repo into it

    go get -d code.justin.tv/web/jax/...
    cd ~/go/src/code.justin.tv/web/jax

Install glide and glide-vc

    brew install glide
    go get github.com/sgotti/glide-vc

And run!

    cd ~/go/src/code.justin.tv/web/jax
    go run api/main.go

To run the updater:

    go run updater/main.go


### Dev Tools

Formatting:

    go fmt ./...

Check for more subtle errors:

    go vet ./...

Tests:

    go get github.com/smartystreets/goconvey
    goconvey // Opens a web browser

Adding dependencies (after adding to/modifying glide.yaml):

    glide update
    glide-vc --only-code --no-tests



Deploying
----------

For all environments, check the following to make sure your feature branch will be safe to merge:
* Grep the api and updater logs, make sure you aren't seeing any new errors.
* Check rollbar. New errors should show up in each respective rollbar instance (staging, prod, etc).
* Check Grafana (https://grafana.prod.us-west2.justin.tv/dashboard/db/jax). Make sure the graphs look reasonable.
* Check the process uptime. `svstat /etc/service/jax_*` and make sure the uptimes look reasonable (for example, that they haven't been restarting constantly).

### Staging

After you've written tests and made sure you don't see any errors in your logs locally, push to staging using the deploy tool (https://clean-deploy.internal.justin.tv/#/web/jax).

Keep in mind that web/web and web/streams-api staging environments talk to jax-staging.

### CR
Before deploying to a production environment (canary included), your change must be CR'd and approved. DO NOT push any code to a jax production environment without first getting approval from someone familiar with the system.

### Canary

After you've verified your changes on staging and gotten your CR approved, push out to canary for at least **30 minutes**.

It's especially important to check Grafana here - Canary takes ~5% of production traffic, and any raises/dips that would occur will manifest in a roughly 5% change.

### Production

Now that your branch has been tested on canary and approved by a CR, merge your branch to master and deploy to production. Keep your eye on the appropriate slack channels (#site-production, #emergency, etc.), and continue to check the logs/rollbar/grafana.

Misc
-----
bundle install --binstubs=.binstubs

## Architecture

**Codebase:** https://git-aws.internal.justin.tv/web/jax <br>
**Summary:** API to track live streams <br>
**Purpose:** Returns liveness of single and multiple streams <br>

<img src="docs/resources/JAX-Algorithm.png" alt="JAX Algorithm" width="800"/>
<img src="docs/resources/JAX-Resources.png" alt="JAX Resources" width="800"/>
