package frontend

import (
	"encoding/json"
	"fmt"
	"net/http"
	"regexp"
	"strings"

	"code.justin.tv/web/jax/db"
)

var channelRgx *regexp.Regexp

func init() {
	channelRgx, _ = regexp.Compile("^[a-z0-9][a-z0-9_]*$")
}

func (fe *frontend) handleGet(w http.ResponseWriter, r *http.Request) {
	q := r.URL.Query()

	id := q.Get("id")
	channel := strings.ToLower(q.Get("channel"))

	var dbErr *db.JaxDbError
	resp := &db.ResultSet{Hits: []db.ChannelResult{}}
	_, _, fields, filters := parseQueryParams(q)
	if len(id) > 0 {
		resp, dbErr = fe.db.GetByID(id, fields, filters)
		if dbErr != nil {
			serveDbError(w, r, dbErr)
			return
		}
		fe.Stats.Inc("response.get_stream_by_id.num_streams", int64(len(resp.Hits)), 0.1)
	} else if len(channel) > 0 && channelRgx.MatchString(channel) {
		resp, dbErr = fe.db.Get(channel, fields, filters)
		if dbErr != nil {
			serveDbError(w, r, dbErr)
			return
		}
		fe.Stats.Inc("response.get_stream.num_streams", int64(len(resp.Hits)), 0.1)
	}

	b, err := json.Marshal(resp)
	if err != nil {
		serveJsonError(w, r, resp, err)
		return
	}
	w.Header().Set("Content-Type", contentType)
	w.Header().Set("Cache-Control", "max-age=60")
	w.WriteHeader(http.StatusOK)
	fmt.Fprintf(w, "%s", b)
}
