package frontend

import (
	"encoding/json"
	"fmt"
	"net/http"
	"strings"

	"code.justin.tv/web/jax/db"
)

// handleStreamList is the handler for the /stream/list endpoint.
func (fe *frontend) handleStreamList(w http.ResponseWriter, r *http.Request) {
	r.ParseForm()
	q := r.Form

	sortField := "viewers"
	if len(q.Get("sort")) > 0 {
		sortField = q.Get("sort")
	}

	limit, offset, fields, filters := parseQueryParams(q)

	var resp *db.ResultSet
	var dbErr *db.JaxDbError
	if len(q.Get("channels")) > 0 {
		resp, dbErr = fe.db.BulkGetByChannel(strings.Split(strings.ToLower(q.Get("channels")), ","), fields, sortField, limit, offset, filters...)
		fe.Stats.Inc("response.get_streams_list_by_channel_name.num_streams", int64(len(resp.Hits)), 0.1)
	} else if len(q.Get("channel_ids")) > 0 {
		resp, dbErr = fe.db.BulkGetByChannelID(strings.Split(strings.ToLower(q.Get("channel_ids")), ","), fields, sortField, limit, offset, filters...)
		fe.Stats.Inc("response.get_streams_list_by_channel_id.num_streams", int64(len(resp.Hits)), 0.1)
	} else {
		emptyResp := &db.ResultSet{
			Total: 0,
			Hits:  []db.ChannelResult{},
		}

		res, jsonErr := json.Marshal(emptyResp)
		if jsonErr != nil {
			serveDbError(w, r, db.NewJaxDbError(jsonErr.Error()))
			return
		}
		w.Header().Set("Content-Type", contentType)
		w.WriteHeader(http.StatusOK)
		fmt.Fprintf(w, "%s", res)
		return
	}
	if dbErr != nil {
		serveDbError(w, r, db.NewJaxDbError(dbErr.Error()))
		return
	}

	res, jsonErr := json.Marshal(resp)
	if jsonErr != nil {
		serveDbError(w, r, db.NewJaxDbError(jsonErr.Error()))
		return
	}

	w.Header().Set("Cache-Control", "no-cache")
	w.Header().Set("Content-Type", contentType)
	w.WriteHeader(http.StatusOK)

	fe.Stats.Inc("response.get_streams_list.num_streams", int64(len(resp.Hits)), 0.1)
	fmt.Fprintf(w, "%s", res)
}
