package frontend

import (
	"encoding/json"
	"net/http"
	"time"
)

type streamEvent struct {
	Channel string `json:"channel"`
}

func (fe *frontend) handleStreamEvent(w http.ResponseWriter, r *http.Request) {
	if r.Method != "POST" && r.Method != "DELETE" {
		w.Header().Add("Allow", "POST")
		w.Header().Add("Allow", "DELETE")
		w.WriteHeader(http.StatusMethodNotAllowed)
		return
	}

	var event streamEvent
	dec := json.NewDecoder(r.Body)
	err := dec.Decode(&event)
	if err != nil {
		serveError(w, r, http.StatusBadRequest, "malformed form body: %v", err)
		return
	}

	if r.Method == "POST" {
		fe.writer.Update(event.Channel, map[string]interface{}{
			"streamlist": map[string]interface{}{
				"last_updated": time.Now().UTC(),
			},
		})
	} else {
		fe.writer.Delete(event.Channel)
	}

	w.WriteHeader(http.StatusOK)
}
