package jax

import (
	"net/url"
	"strconv"
	"strings"
	"testing"

	. "github.com/smartystreets/goconvey/convey"
)

func TestOptions(t *testing.T) {
	Convey("EqualityFilter", t, func() {
		testField := "dlskjf"
		testValue := "sgshjlts"
		f := EqualityFilter(testField, testValue)
		r := StreamsOptions{
			Filters: []Filter{f},
		}

		params := r.urlParams()
		So(params.Encode(), ShouldContainSubstring, testField+"="+testValue)
	})

	Convey("MaxHeightFilter", t, func() {
		testValue := "sgshjlts"
		f := MaxHeightFilter(testValue)
		r := StreamsOptions{
			Filters: []Filter{f},
		}

		params := r.urlParams()
		So(params.Encode(), ShouldContainSubstring, "usher.max_height="+testValue)
	})

	Convey("XboxHeartbeatFilter", t, func() {
		f := XboxHeartbeatFilter(false)
		r := StreamsOptions{
			Filters: []Filter{f},
		}

		params := r.urlParams()
		So(params.Encode(), ShouldContainSubstring, "xbox_heartbeat=false")

		f = XboxHeartbeatFilter(true)
		r = StreamsOptions{
			Filters: []Filter{f},
		}

		params = r.urlParams()
		So(params.Encode(), ShouldContainSubstring, "xbox_heartbeat=true")
	})

	Convey("StreamTypeFilter", t, func() {
		testValue := "sgshjlts"
		f := StreamTypeFilter(testValue)
		r := StreamsOptions{
			Filters: []Filter{f},
		}

		params := r.urlParams()
		So(params.Encode(), ShouldContainSubstring, "stream_type="+testValue)
	})

	Convey("limit", t, func() {
		testLimit := 10
		r := StreamsOptions{
			Pagination: PaginationOptions{
				Limit: testLimit,
			},
		}

		params := r.urlParams()
		So(params.Encode(), ShouldContainSubstring, "size="+strconv.Itoa(testLimit))
	})

	Convey("offset", t, func() {
		testOffset := 10
		r := StreamsOptions{
			Pagination: PaginationOptions{
				Offset: testOffset,
			},
		}

		params := r.urlParams()
		So(params.Encode(), ShouldContainSubstring, "from="+strconv.Itoa(testOffset))
	})

	Convey("fields", t, func() {
		testFields := []string{"blehc", "blach"}
		r := StreamsOptions{
			Fields: testFields,
		}

		params := r.urlParams()
		So(params.Encode(), ShouldContainSubstring, "fields="+url.QueryEscape(strings.Join(testFields, ",")))
	})

}
