package logic

import (
	"code.justin.tv/web/jax/common/config"
	"code.justin.tv/web/jax/common/hs/backend"
	. "code.justin.tv/web/jax/common/hs/models"
)

const (
	soloQueue = "RANKED_SOLO_5x5"
)

type Logic interface {
	GetHSDeepMetadata(ch string) (deepmetadata HearthstoneDeepmetadataEvent, err error)
}

type logicImpl struct {
	backend backend.HSBackend
	config  *config.Config
}

var _ Logic = new(logicImpl)

// New creates a new Logic struct given a HSBackend struct
func New(conf *config.Config, b backend.HSBackend) (Logic, error) {
	return &logicImpl{
		backend: b,
		config:  conf,
	}, nil
}

// GetSummonerNames takes a list of Twitch channels and returns a list of TwitchSummoner objects
func (T *logicImpl) GetHSDeepMetadata(ch string) (hsDeepmetadata HearthstoneDeepmetadataEvent, err error) {
	hsDeepmetadata = T.backend.FetchHSDeepMetadata(ch)
	return
}
