package models

import (
	"time"
)

// swagger:model HSStreamDeepMetadata
type HSStreamDeepMetadata struct {
	HearthstoneData HearthstoneDeepmetadataEvent `json:"HEARTHSTONE,omitempty"` // optional
}

// HSProperties describes all the fields returned by the deepmetadata API which
type HSProperties struct {
	Login       string `json:"login" internal:"channel"`
	TwitchID    string `json:"channel_id"`
	BroadcastID int64  `json:"-"`
	Viewers     int64  `json:"-"`

	BroadcasterHeroName  string `json:"broadcaster_hero_name,omitempty"`
	BroadcasterHeroClass string `json:"broadcaster_hero_class,omitempty"`

	OpponentHeroName  string `json:"opponent_hero_name,omitempty"`
	OpponentHeroClass string `json:"opponent_hero_class,omitempty"`

	HSGameMode string `json:"game_mode,omitempty"`

	GameState string `json:"state,omitempty"`
}

// HearthstoneDeepmetadataEvent contains the extracted deepmetadata about a stream
type HearthstoneDeepmetadataEvent struct {
	State    string              `json:"state,omitempty"`
	Heroes   []HearthstoneHero   `json:"heroes,omitempty"`    // optional
	GameMode HearthstoneGameMode `json:"game_mode,omitempty"` // optional
	Outcome  GameOutcome         `json:"outcome,omitempty"`   // optional
}

type HearthstoneHero struct {
	HeroName      string        `json:"name,omitempty"`
	HeroClass     string        `json:"class,omitempty"`
	DetectionTime time.Duration `json:"detection_time_sec,omitempty"`
	Label         string        `json:"label,omitempty"`
	HeroType      string        `json:"type,omitempty"`
}

type HearthstoneGameMode struct {
	// DetectionTime time.Duration `json:"detection_time_sec,omitempty"`
	Mode string `json:"name,omitempty"`
}

type GameOutcome struct {
	// DetectionTime time.Duration `json:"detection_time_sec,omitempty"`
	Result string `json:"result,omitempty"`
}
