package jsonable

import (
	"encoding/json"
	"fmt"
)

// RawString is a string with JSON-support.
type RawString string

var _ json.Marshaler = RawString("")
var _ json.Unmarshaler = (*RawString)(nil)

// MarshalJSON takes this RawString and JSON-encodes it.
func (T RawString) MarshalJSON() ([]byte, error) {
	return []byte(T), nil
}

// UnmarshalJSON takes the JSON-encoded input and puts it into this RawString
func (T *RawString) UnmarshalJSON(data []byte) error {
	if T == nil {
		return fmt.Errorf("jsonable.RawString: UnmarshalJSON on nil pointer")
	}
	*T = RawString(data)
	return nil
}
