package jsonable

import (
	"encoding/json"
	"time"
)

type Time time.Time

var _ json.Unmarshaler = new(Time)
var _ json.Marshaler = *new(Time)

var loc, _ = time.LoadLocation("America/Los_Angeles")

func (T *Time) UnmarshalJSON(b []byte) (err error) {
	var t time.Time

	if t, err = time.Parse(`"`+time.RFC3339+`"`, string(b)); err == nil {
		*T = Time(t)
	}
	return
}

func (T Time) MarshalJSON() (b []byte, err error) {
	b = []byte(time.Time(T).Format(time.RFC3339))
	return
}
