package backend

import (
	. "code.justin.tv/web/jax/common/lol/models"
	// . "github.com/smartystreets/goconvey/convey"
)

type Error struct {
	Status  int    `json:"status_code"`
	Message string `json:"message"`
}

var test1 = TwitchSummoner{
	TwitchID:     "test1",
	SummonerName: "sum1",
	SummonerID:   1,
	Region:       "na",
}
var test2 = TwitchSummoner{
	TwitchID:     "test2",
	SummonerName: "sum2",
	SummonerID:   2,
	Region:       "na",
}
var test3 = TwitchSummoner{
	TwitchID:     "test3",
	SummonerName: "sum3",
	SummonerID:   3,
	Region:       "na",
}
var moreThanOne = []string{"test1", "test2", "test3"}
var moreThanOneExpected = []TwitchSummoner{test1, test2, test3}
var one = []string{"test1"}
var oneExpected = []TwitchSummoner{test1}
var summonerIDResponse = map[string]SummonerName{
	"foo": SummonerName{
		ID:   1,
		Name: "foo",
	},
	"bar": SummonerName{
		ID:   2,
		Name: "bar",
	},
	"baz": SummonerName{
		ID:   3,
		Name: "baz",
	},
}
var summonerRankResponse = map[string][]SummonerRank{
	"1": []SummonerRank{
		SummonerRank{
			Queue: "RANKED_SOLO_5x5",
			Tier:  "PLASTIC",
		},
	},
	"2": []SummonerRank{
		SummonerRank{
			Queue: "RANKED_SOLO_5x5",
			Tier:  "WOOD",
		},
	},
	"3": []SummonerRank{
		SummonerRank{
			Queue: "RANKED_SOLO_5x5",
			Tier:  "LEATHER",
		},
	},
}

var dummyMatch = Match{
	GameStartTime: 3154,
	Participants: []Participant{
		Participant{
			SummonerName: "foo",
			SummonerID:   1,
			ChampionID:   1,
		},
		Participant{
			SummonerName: "bar",
			SummonerID:   2,
			ChampionID:   2,
		},
		Participant{
			SummonerName: "baz",
			SummonerID:   3,
			ChampionID:   3,
		},
		Participant{
			SummonerName: "qux",
			SummonerID:   4,
			ChampionID:   4,
		},
		Participant{
			SummonerName: "quux",
			SummonerID:   5,
			ChampionID:   5,
		},
	},
}

var errorResponse = Error{
	Status:  404,
	Message: "Not Found",
}

// func setupServer() *httptest.Server {
// 	ts := httptest.NewServer(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
// 		uri, _ := url.Parse(r.RequestURI)
// 		params := uri.Query()
// 		pathTokens := strings.Split(uri.Path, "/")
// 		if strings.Contains(uri.Path, "summonername") {
// 			ids := params["twitchid"]
// 			tok := strings.Split(ids[0], ",")
// 			if len(tok) == 3 {
// 				apiutils.ServeJSON(w, moreThanOneExpected)
// 			} else if len(tok) == 1 && tok[0] != "" {
// 				apiutils.ServeJSON(w, oneExpected)
// 			} else {
// 				apiutils.ServeJSON(w, []TwitchSummoner{})
// 			}
// 		} else if strings.Contains(uri.Path, "summoner/by-name") {
// 			ids := pathTokens[len(pathTokens)-1]
// 			tok := strings.Split(string(ids), ",")
// 			if len(tok) == 3 {
// 				apiutils.ServeJSON(w, summonerIDResponse)
// 			}
// 		} else if strings.Contains(uri.Path, "league/by-summoner") {
// 			ids := pathTokens[len(pathTokens)-2]
// 			tok := strings.Split(string(ids), ",")
// 			if len(tok) == 3 {
// 				apiutils.ServeJSON(w, summonerRankResponse)
// 			}
// 		} else if strings.Contains(uri.Path, "getSpectatorGameInfo") {
// 			id, _ := strconv.Atoi(pathTokens[len(pathTokens)-1])
// 			if id >= 1 && id <= 5 {
// 				apiutils.ServeJSON(w, dummyMatch)
// 			} else {
// 				apiutils.ServeJSON(w, errorResponse)
// 			}
// 		}
// 	}))
// 	return ts
// }

// func setupBackend(ts *httptest.Server) Backend {
// 	host := strings.Split(ts.URL, "//")[1]
// 	backend, _ := New(&config.Config{
// 		RiotHost:    host + "%s",
// 		RiotScheme:  "http",
// 		KalistaHost: host,
// 	})
// 	return backend
// }

// func TestFetchSummonerNames(t *testing.T) {
// 	ts := setupServer()
// 	backend := setupBackend(ts)
// 	var response []TwitchSummoner
// 	Convey("When fetching summoner names", t, func() {
// 		Convey("Should get a json", func() {
// 			response = backend.FetchSummonerNames(moreThanOne)
// 			So(response, ShouldResemble, moreThanOneExpected)

// 			response = backend.FetchSummonerNames(one)
// 			So(response, ShouldResemble, oneExpected)
// 		})
// 		Convey("Should get an empty json", func() {
// 			response = backend.FetchSummonerNames([]string{})
// 			So(response, ShouldBeEmpty)
// 		})
// 	})
// }

// func TestFetchSummonerIDs(t *testing.T) {
// 	ts := setupServer()
// 	backend := setupBackend(ts)
// 	var response SummonerName
// 	Convey("When fetching summoner ids", t, func() {
// 		Convey("Should get a json", func() {
// 			response = backend.FetchSummonerIDs("", []string{"foo", "bar", "baz"})
// 			So(response, ShouldResemble, summonerIDResponse)
// 		})
// 		// this will throw an error but that's okay–as long as it doesn't panic.
// 		Convey("Should get an empty json", func() {
// 			response = backend.FetchSummonerIDs("", []string{})
// 			So(response, ShouldBeEmpty)
// 		})
// 	})
// }

// func TestFetchSummonerRanks(t *testing.T) {
// 	ts := setupServer()
// 	backend := setupBackend(ts)
// 	var response map[string][]SummonerRank
// 	Convey("When fetching summoner rank", t, func() {
// 		Convey("Should get a json", func() {
// 			response = backend.FetchSummonerRanks("", []int64{1, 2, 3})
// 			So(response, ShouldResemble, summonerRankResponse)
// 		})
// 		// this will throw an error but that's okay–as long as it doesn't panic.
// 		Convey("Should get an empty json", func() {
// 			response = backend.FetchSummonerRanks("", []int64{})
// 			So(response, ShouldBeEmpty)
// 		})
// 	})
// }

// func TestFetchCurrentMatch(t *testing.T) {
// 	ts := setupServer()
// 	backend := setupBackend(ts)
// 	var response Match
// 	Convey("When fetching a match", t, func() {
// 		Convey("Should get a json if they are in game", func() {
// 			response = backend.FetchCurrentMatch("", 1)
// 			So(response, ShouldResemble, dummyMatch)
// 			response = backend.FetchCurrentMatch("", 3)
// 			So(response, ShouldResemble, dummyMatch)
// 			response = backend.FetchCurrentMatch("", 5)
// 			So(response, ShouldResemble, dummyMatch)
// 		})
// 		Convey("Should return an empty match if they aren't in a game", func() {
// 			response = backend.FetchCurrentMatch("", 6)
// 			So(response, ShouldResemble, Match{})
// 			response = backend.FetchCurrentMatch("", -1)
// 			So(response, ShouldResemble, Match{})
// 		})
// 	})
// }
