package logic

import (
	"testing"

	"code.justin.tv/web/jax/common/config"
	// . "code.justin.tv/web/jax/common/lol/models"
	. "github.com/smartystreets/goconvey/convey"
)

func mockConfig() *config.Config {
	return &config.Config{
		RiotAPIToken: "",
		RiotHost:     "",
		KalistaHost:  "",
		RiotRegionPlatform: map[string]string{
			"br":   "BR1",
			"eune": "EUN1",
			"euw":  "EUW1",
			"jp":   "JP1",
			"kr":   "KR",
			"lan":  "LA1",
			"las":  "LA2",
			"na":   "NA1",
			"oce":  "OC1",
			"tr":   "TR1",
			"ru":   "RU",
			"pbe":  "PBE1",
		},
	}
}

func TestRegionToPlatformID(t *testing.T) {
	logic := logicImpl{
		config: mockConfig(),
	}
	Convey("works for empty", t, func() {
		platform := logic.regionToPlatformID("")
		So(platform, ShouldEqual, "NA1")
	})

	Convey("works for region", t, func() {
		platform := logic.regionToPlatformID("lan")
		So(platform, ShouldEqual, "LA1")
	})
	// mockBackend := new(mocks.Backend)
	// test1 := TwitchSummoner{
	// 	TwitchID:     "test1",
	// 	SummonerName: "sum1",
	// 	SummonerID:   123,
	// 	Region:       "na",
	// }
	// test2 := TwitchSummoner{
	// 	TwitchID:     "test2",
	// 	SummonerName: "sum2",
	// 	SummonerID:   234,
	// 	Region:       "na",
	// }
	// test3 := TwitchSummoner{
	// 	TwitchID:     "test3",
	// 	SummonerName: "sum3",
	// 	SummonerID:   345,
	// 	Region:       "na",
	// }
	// moreThanOne := []string{"test1", "test2", "test3"}
	// moreThanOneExpected := []TwitchSummoner{test1, test2, test3}
	// one := []string{"test1"}
	// oneExpected := []TwitchSummoner{test1}
	// none := []string{}
	// noneExpected := []TwitchSummoner{}
	// mockBackend.On("FetchSummonerNames", moreThanOne).Return(moreThanOneExpected)
	// mockBackend.On("FetchSummonerNames", one).Return(oneExpected)
	// mockBackend.On("FetchSummonerNames", none).Return(noneExpected)
	// logic, _ := New(&config.Config{}, mockBackend)

	// Convey("When getting summoner names", t, func() {
	// 	var summonerName []TwitchSummoner
	// 	Convey("Should get a map of Twitch IDs to summoner names", func() {
	// 		summonerName, _ = logic.GetSummonerNames(moreThanOne)
	// 		So(summonerName, ShouldResemble, moreThanOneExpected)

	// 		summonerName, _ = logic.GetSummonerNames(one)
	// 		So(summonerName, ShouldResemble, oneExpected)
	// 	})
	// 	Convey("Should be empty", func() {
	// 		summonerName, _ = logic.GetSummonerNames(none)
	// 		So(summonerName, ShouldBeEmpty)
	// 	})
	// })
}
