package mocks

import backend "code.justin.tv/web/jax/common/lol/backend"
import mock "github.com/stretchr/testify/mock"
import models "code.justin.tv/web/jax/common/lol/models"

// Backend is an autogenerated mock type for the Backend type
type Backend struct {
	mock.Mock
}

// FetchCurrentMatch provides a mock function with given fields: platform, summonerID
func (_m *Backend) FetchCurrentMatch(platform string, summonerID int64) models.Match {
	ret := _m.Called(platform, summonerID)

	var r0 models.Match
	if rf, ok := ret.Get(0).(func(string, int64) models.Match); ok {
		r0 = rf(platform, summonerID)
	} else {
		r0 = ret.Get(0).(models.Match)
	}

	return r0
}

// FetchSummonerName provides a mock function with given fields: twitchID
func (_m *Backend) FetchSummonerName(twitchID string) models.TwitchSummoner {
	ret := _m.Called(twitchID)

	var r0 models.TwitchSummoner
	if rf, ok := ret.Get(0).(func(string) models.TwitchSummoner); ok {
		r0 = rf(twitchID)
	} else {
		r0 = ret.Get(0).(models.TwitchSummoner)
	}

	return r0
}

// FetchSummonerRank provides a mock function with given fields: platform, summonerID
func (_m *Backend) FetchSummonerRank(platform string, summonerID int64) models.SummonerRank {
	ret := _m.Called(platform, summonerID)

	var r0 models.SummonerRank
	if rf, ok := ret.Get(0).(func(string, int64) models.SummonerRank); ok {
		r0 = rf(platform, summonerID)
	} else {
		r0 = ret.Get(0).(models.SummonerRank)
	}

	return r0
}

var _ backend.Backend = (*Backend)(nil)
