package models

// LoLProperties describes all the fields returned by the League of Legends API which
// should be exposed through Jax.
type LoLProperties struct {
	Login         string `json:"login" internal:"channel"`
	TwitchID      string `json:"channel_id"`
	IsConnected   bool   `json:"connected"`
	SummonerName  string `json:"summoner_name"`
	SummonerID    int64  `json:"summoner_id"`
	Region        string `json:"region"`
	ChampionID    int    `json:"champion_id"`
	GameStartTime int64  `json:"game_time"`
	BroadcastID   int64  `json:"-"`
	Viewers       int64  `json:"-"`
}

type LoLRankProperties struct {
	Login       string `json:"login" internal:"channel"`
	Rank        string `json:"summoner_rank"`
	Division    string `json:"summoner_division"`
	RankNumeric int    `json:"summoner_rank_numeric"`
}

// TwitchSummoner is a relational struct encapsulating Twitch IDs and Summoner Names
type TwitchSummoner struct {
	TwitchID     string `json:"twitch_id"`
	SummonerName string `json:"summoner_name"`
	SummonerID   int64  `json:"summoner_id"`
	Region       string `json:"region"`
}

// SummonerRank is the return object used for unmarshaling
type SummonerRank struct {
	Queue   string        `json:"queue"`
	Tier    string        `json:"tier"`
	Entries []LeagueEntry `json:"entries"`
}

// LeagueEntry is the return object used for unmarshaling
type LeagueEntry struct {
	Division string `json:"division"`
}

// SummonerName is the return object used for unmarshaling; this is returned by Riot's API
type SummonerName struct {
	ID            int64  `json:"id"`
	Name          string `json:"name"`
	ProfileIconID int    `json:"profileIconID"`
}

// Match is the return object used for unmarshaling
type Match struct {
	GameStartTime int64         `json:"gameStartTime"`
	Participants  []Participant `json:"participants"`
}

// Participant is the return object used for unmarshaling
type Participant struct {
	SummonerName string `json:"summonerName"`
	SummonerID   int64  `json:"summonerID"`
	ChampionID   int    `json:"championID"`
}
