package logic

import (
	"code.justin.tv/web/jax/common/config"
	"code.justin.tv/web/jax/common/overwatch/backend"
	. "code.justin.tv/web/jax/common/overwatch/models"
)

const (
	soloQueue = "RANKED_SOLO_5x5"
)

type Logic interface {
	GetOverwatchDeepMetadata(ch string) (deepmetadata OverwatchDeepmetadataEvent, err error)
}

type logicImpl struct {
	backend backend.OverwatchBackend
	config  *config.Config
}

var _ Logic = new(logicImpl)

// New creates a new Logic struct given a OverwatchBackend struct
func New(conf *config.Config, b backend.OverwatchBackend) (Logic, error) {
	return &logicImpl{
		backend: b,
		config:  conf,
	}, nil
}

// GetSummonerNames takes a list of Twitch channels and returns a list of TwitchSummoner objects
func (T *logicImpl) GetOverwatchDeepMetadata(ch string) (owDeepmetadata OverwatchDeepmetadataEvent, err error) {
	owDeepmetadata = T.backend.FetchOverwatchDeepMetadata(ch)
	return
}
