package models

import (
	"time"
)

// swagger:model OverwatchStreamDeepMetadata
type OverwatchStreamDeepMetadata struct {
	OverwatchData OverwatchDeepmetadataEvent `json:"OVERWATCH,omitempty"`
}

// OverwatchProperties describes all the fields returned by the deepmetadata API which
type OverwatchProperties struct {
	Login       string `json:"login" internal:"channel"`
	TwitchID    string `json:"channel_id"`
	BroadcastID int64  `json:"-"`
	Viewers     int64  `json:"-"`

	BroadcasterCharacter        string `json:"broadcaster_character,omitempty"`
	BroadcasterCharacterRole    string `json:"broadcaster_character_role,omitempty"`
	BroadcasterCharacterAbility string `json:"broadcaster_character_ability,omitempty"`

	GameState string `json:"state,omitempty"`
}

// swagger:model OverwatchDeepmetadataEvent
type OverwatchDeepmetadataEvent struct {
	State string `json:"state,omitempty"`
	// StateStartTime time.Duration        `json:"state_start_time_sec,omitempty"`
	Characters []OverwatchCharacter `json:"heroes,omitempty"`
	// GameMode		OverwatchGameMode 		`json:"gamemode,omitempty"`	// optional
	Outcome GameOutcome `json:"outcome,omitempty"` // optional
}

// swagger:model OverwatchPlayer
type OverwatchCharacter struct {
	Name          string        `json:"name,omitempty"`
	Role          string        `json:"role,omitempty"`
	Ability       string        `json:"ability,omitempty"`
	DetectionTime time.Duration `json:"detection_time_sec,omitempty"`
	Label         string        `json:"label,omitempty"`
}

// swagger:model GameOutcome
type GameOutcome struct {
	// DetectionTime time.Duration `json:"detection_time_sec,omitempty"`
	Result string `json:"result,omitempty"`
}
