package backend

import (
	"context"
	"strconv"

	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/revenue/moneypenny/client"
	"code.justin.tv/web/jax/common/config"
)

type PartnershipsBackend interface {
	IsPartner(int) (bool, error)
}

type backendImpl struct {
	client moneypenny.Client
}

var _ PartnershipsBackend = new(backendImpl)

func New(conf *config.Config) (PartnershipsBackend, error) {
	client, err := moneypenny.NewClient(twitchclient.ClientConf{
		Host: conf.MoneypennyHost,
	})
	return &backendImpl{
		client: client,
	}, err
}

func (T *backendImpl) IsPartner(channelID int) (bool, error) {
	resp, err := T.client.GetUserPayoutType(context.Background(), strconv.Itoa(channelID), nil)
	if err != nil {
		return false, err
	}

	return resp.IsPartner, nil
}
