package logic

import (
	"code.justin.tv/web/jax/common/config"
	"code.justin.tv/web/jax/common/pubg/backend"
	. "code.justin.tv/web/jax/common/pubg/models"
)

type Logic interface {
	GetPUBGDeepMetadata(ch string) (deepmetadata PUBGDeepmetadataEvent, err error)
}

type logicImpl struct {
	backend backend.PUBGBackend
	config  *config.Config
}

var _ Logic = new(logicImpl)

// New creates a new Logic struct given a PUBGBackend struct
func New(conf *config.Config, b backend.PUBGBackend) (Logic, error) {
	return &logicImpl{
		backend: b,
		config:  conf,
	}, nil
}

// GetSummonerNames takes a list of Twitch channels and returns a list of TwitchSummoner objects
func (T *logicImpl) GetPUBGDeepMetadata(ch string) (PUBGDeepmetadataEvent, error) {
	return T.backend.FetchPUBGDeepMetadata(ch)
}
