package models

import (
	"time"
)

// swagger:model PUBGStreamDeepMetadata
type PUBGStreamDeepMetadata struct {
	PUBGData PUBGDeepmetadataEvent `json:"PLAYERUNKNOWNS_BATTLEGROUNDS,omitempty"`
}

// PUBGProperties describes all the fields returned by the deepmetadata API which
type PUBGProperties struct {
	Login       string `json:"login" internal:"channel"`
	TwitchID    string `json:"channel_id"`
	BroadcastID int64  `json:"-"`
	Viewers     int64  `json:"-"`

	PlayerAliveCount int `json:"player_alive_count,omitempty"`

	PUBGGameMode string `json:"game_mode,omitempty"`

	GameState string `json:"state,omitempty"`
}

// swagger:model PUBGDeepmetadataEvent
type PUBGDeepmetadataEvent struct {
	State             string                 `json:"state,omitempty"`
	PlayerAliveCounts []PUBGPlayerAliveCount `json:"player_alive,omitempty"` // optional
	GameMode          PUBGGameMode           `json:"game_mode,omitempty"`    // optional
}

// swagger:model PUBGPlayerAliveCount
type PUBGPlayerAliveCount struct {
	Count         int           `json:"count,omitempty"`
	DetectionTime time.Duration `json:"detection_time_sec,omitempty"`
}

// swagger:model PUBGGameMode
type PUBGGameMode struct {
	Mode string `json:"name,omitempty"`
}
