package reflect

import (
	"fmt"
	"reflect"
	"strings"
)

// propNames returns a map of the columns of an interface{} based on the field
// tags.
func PropNames(in interface{}) (map[string]int, error) {
	m := make(map[string]int)
	chT := reflect.ValueOf(in).Type()
	for i := 0; i < chT.NumField(); i++ {
		name := strings.SplitN(chT.Field(i).Tag.Get("internal"), ",", 2)[0]
		if name == "-" {
			continue
		}
		if name == "" {
			name = strings.SplitN(chT.Field(i).Tag.Get("json"), ",", 2)[0]
		}
		if name == "-" {
			continue
		}
		if _, ok := m[name]; ok {
			return nil, fmt.Errorf("duplicate property %#v at field %v",
				name, chT.Field(i).Name)
		}
		m[name] = i
	}
	return m, nil
}
