package run

import (
	"expvar"
	"runtime"
)

func init() {
	m := new(expvar.Map).Init()
	m.Set("compiler", expvar.Func(func() interface{} { return runtime.Compiler }))
	m.Set("goarch", expvar.Func(func() interface{} { return runtime.GOARCH }))
	m.Set("goos", expvar.Func(func() interface{} { return runtime.GOOS }))

	m.Set("gomaxprocs", expvar.Func(func() interface{} { return runtime.GOMAXPROCS(0) }))
	m.Set("num_cpu", expvar.Func(func() interface{} { return runtime.NumCPU() }))
	m.Set("num_goroutine", expvar.Func(func() interface{} { return runtime.NumGoroutine() }))
	m.Set("version", expvar.Func(func() interface{} { return runtime.Version() }))
	expvar.Publish("runtime", m)
}
