package stats

import (
	"fmt"
	"log"
	"os"
	"time"

	"code.justin.tv/web/jax/common/config"

	"github.com/cactus/go-statsd-client/statsd"
)

// InitStatsd creates a stats.Statter with an environment
func InitStatsd(conf *config.Config) statsd.Statter {
	var stats statsd.Statter

	statsdHostport := conf.StatsHostPort
	if len(statsdHostport) > 0 {
		hostName, err := os.Hostname()
		if err != nil {
			hostName = "unknown_host"
		}

		prefix := fmt.Sprintf("jax.%v.%v", conf.Environment, hostName)

		if stats, err = statsd.NewBufferedClient(statsdHostport, prefix, 1*time.Second, 512); err != nil {
			log.Fatalf("StatsD configuration error: %v", err)
		}

		log.Printf("Connected to StatsD at %s\n", statsdHostport)
	} else {
		stats, _ = statsd.NewNoopClient()
	}

	return stats
}
