package usher

/*
BroadcastPlatformMapping maps usher.broadcaster to broadcast_platform
*/
func BroadcastPlatformMapping(broadcaster string) string {
	switch broadcaster {
	case "watch_party":
		return "watch_party"
	case "watch_party_premiere":
		return "premiere"
	case "watch_party_rerun":
		return "rerun"
	case "spectre":
		return "playlist"
	case "ios", "android":
		return "mobile"
	case "candybox":
		return "xbox"
	case "octodad":
		return "ps4"
	default:
		return "live"
	}
}

/*
StreamTypeMapping maps usher.broadcaster to stream_type
*/
func StreamTypeMapping(broadcaster string) string {
	switch broadcaster {
	case "watch_party":
		return "watch_party"
	case "watch_party_premiere":
		return "premiere"
	case "watch_party_rerun":
		return "rerun"
	case "spectre":
		return "playlist"
	default:
		return "live"
	}
}
