package xbox

import (
	"testing"
	"time"
)

type timeCase struct {
	raw    string
	parsed time.Time
}

func TestParseMSTTime(t *testing.T) {
	for _, test := range []timeCase{
		timeCase{
			raw:    "2016-05-26T15:04:05",
			parsed: time.Date(2016, time.May, 26, 15, 4, 5, 0, time.UTC),
		},
		timeCase{
			raw:    "2016-05-26T15:04:05.5Z",
			parsed: time.Date(2016, time.May, 26, 15, 4, 5, 500000000, time.UTC),
		},
		timeCase{
			raw:    "2016-05-26T15:04:05.0Z",
			parsed: time.Date(2016, time.May, 26, 15, 4, 5, 0, time.UTC),
		},
		timeCase{
			raw:    "2016-05-26T15:04:05.5678Z",
			parsed: time.Date(2016, time.May, 26, 15, 4, 5, 567800000, time.UTC),
		},
		timeCase{
			raw:    "2016-05-26T15:04:05.1234567Z",
			parsed: time.Date(2016, time.May, 26, 15, 4, 5, 123456700, time.UTC),
		},
		timeCase{
			raw:    "2016-05-26T15:04:05.567890123Z",
			parsed: time.Date(2016, time.May, 26, 15, 4, 5, 567890123, time.UTC),
		},
	} {
		parsed := parseMSTime(test.raw)
		if !parsed.Equal(test.parsed) {
			t.Errorf("incorrect parsing for case '%s', got '%+v' but expected '%+v'", test.raw, parsed, test.parsed)
		}
	}
}
