#!/usr/bin/env bash

HUP_TIME=2
RESTART_TIME=12

cd /etc/service
for x in `ls -d *jax*`; do
    sudo svc -d $x
    sleep $HUP_TIME
    sudo svstat $x | grep pid
    if [ $? -eq 0 ]; then
        echo "$x failed to HUP; KILLing"
        sudo svc -kd $x
        sleep 1
    fi

    sudo svc -u $x
    sleep $RESTART_TIME

    # Ensure process isn't flapping
    UPTIME=$(sudo svstat $x | sed -e 's/.* up (pid [0-9]*) \([0-9]*\) seconds.*/\1/')
    number_regex='^[0-9]+$'
    if ! [[ $UPTIME =~ $number_regex ]]; then
        echo "Process failed to start" 1>&2
        exit 1
    fi
    if (( $UPTIME < $RESTART_TIME/4 )); then
        echo "Process failed to remain up" 1>&2
        exit 1
    fi
done
