package mocks

import db "code.justin.tv/web/jax/db"
import mock "github.com/stretchr/testify/mock"
import query "code.justin.tv/web/jax/db/query"

// JaxReader is an autogenerated mock type for the JaxReader type
type JaxReader struct {
	mock.Mock
}

// Aggregate provides a mock function with given fields: q
func (_m *JaxReader) Aggregate(q query.AggregationQuery) ([]db.Aggregate, *db.JaxDbError) {
	ret := _m.Called(q)

	var r0 []db.Aggregate
	if rf, ok := ret.Get(0).(func(query.AggregationQuery) []db.Aggregate); ok {
		r0 = rf(q)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]db.Aggregate)
		}
	}

	var r1 *db.JaxDbError
	if rf, ok := ret.Get(1).(func(query.AggregationQuery) *db.JaxDbError); ok {
		r1 = rf(q)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*db.JaxDbError)
		}
	}

	return r0, r1
}

// BulkGetByChannel provides a mock function with given fields: channels, fields, sortField, limit, offset, filters
func (_m *JaxReader) BulkGetByChannel(channels []string, fields []string, sortField string, limit int, offset int, filters ...query.Filter) (*db.ResultSet, *db.JaxDbError) {
	ret := _m.Called(channels, fields, sortField, limit, offset, filters)

	var r0 *db.ResultSet
	if rf, ok := ret.Get(0).(func([]string, []string, string, int, int, ...query.Filter) *db.ResultSet); ok {
		r0 = rf(channels, fields, sortField, limit, offset, filters...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*db.ResultSet)
		}
	}

	var r1 *db.JaxDbError
	if rf, ok := ret.Get(1).(func([]string, []string, string, int, int, ...query.Filter) *db.JaxDbError); ok {
		r1 = rf(channels, fields, sortField, limit, offset, filters...)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*db.JaxDbError)
		}
	}

	return r0, r1
}

// BulkGetByChannelID provides a mock function with given fields: channelIDs, fields, sortField, limit, offset, filters
func (_m *JaxReader) BulkGetByChannelID(channelIDs []string, fields []string, sortField string, limit int, offset int, filters ...query.Filter) (*db.ResultSet, *db.JaxDbError) {
	ret := _m.Called(channelIDs, fields, sortField, limit, offset, filters)

	var r0 *db.ResultSet
	if rf, ok := ret.Get(0).(func([]string, []string, string, int, int, ...query.Filter) *db.ResultSet); ok {
		r0 = rf(channelIDs, fields, sortField, limit, offset, filters...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*db.ResultSet)
		}
	}

	var r1 *db.JaxDbError
	if rf, ok := ret.Get(1).(func([]string, []string, string, int, int, ...query.Filter) *db.JaxDbError); ok {
		r1 = rf(channelIDs, fields, sortField, limit, offset, filters...)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*db.JaxDbError)
		}
	}

	return r0, r1
}

// Get provides a mock function with given fields: channel, fields, filters
func (_m *JaxReader) Get(channel string, fields []string, filters []query.Filter) (*db.ResultSet, *db.JaxDbError) {
	ret := _m.Called(channel, fields, filters)

	var r0 *db.ResultSet
	if rf, ok := ret.Get(0).(func(string, []string, []query.Filter) *db.ResultSet); ok {
		r0 = rf(channel, fields, filters)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*db.ResultSet)
		}
	}

	var r1 *db.JaxDbError
	if rf, ok := ret.Get(1).(func(string, []string, []query.Filter) *db.JaxDbError); ok {
		r1 = rf(channel, fields, filters)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*db.JaxDbError)
		}
	}

	return r0, r1
}

// GetByID provides a mock function with given fields: channel, fields, filters
func (_m *JaxReader) GetByID(channel string, fields []string, filters []query.Filter) (*db.ResultSet, *db.JaxDbError) {
	ret := _m.Called(channel, fields, filters)

	var r0 *db.ResultSet
	if rf, ok := ret.Get(0).(func(string, []string, []query.Filter) *db.ResultSet); ok {
		r0 = rf(channel, fields, filters)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*db.ResultSet)
		}
	}

	var r1 *db.JaxDbError
	if rf, ok := ret.Get(1).(func(string, []string, []query.Filter) *db.JaxDbError); ok {
		r1 = rf(channel, fields, filters)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*db.JaxDbError)
		}
	}

	return r0, r1
}

// Lease provides a mock function with given fields: statName, bufferSize, scanFilters
func (_m *JaxReader) Lease(statName string, bufferSize int, scanFilters ...query.Filter) chan []db.ChannelResult {
	ret := _m.Called(statName, bufferSize, scanFilters)

	var r0 chan []db.ChannelResult
	if rf, ok := ret.Get(0).(func(string, int, ...query.Filter) chan []db.ChannelResult); ok {
		r0 = rf(statName, bufferSize, scanFilters...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(chan []db.ChannelResult)
		}
	}

	return r0
}

// Scan provides a mock function with given fields: statName, bufferSize, scanFilters
func (_m *JaxReader) Scan(statName string, bufferSize int, scanFilters ...query.Filter) chan []db.ChannelResult {
	ret := _m.Called(statName, bufferSize, scanFilters)

	var r0 chan []db.ChannelResult
	if rf, ok := ret.Get(0).(func(string, int, ...query.Filter) chan []db.ChannelResult); ok {
		r0 = rf(statName, bufferSize, scanFilters...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(chan []db.ChannelResult)
		}
	}

	return r0
}

// Search provides a mock function with given fields: args, q
func (_m *JaxReader) Search(args map[string]interface{}, q query.SearchQuery) (*db.ResultSet, *db.JaxDbError) {
	ret := _m.Called(args, q)

	var r0 *db.ResultSet
	if rf, ok := ret.Get(0).(func(map[string]interface{}, query.SearchQuery) *db.ResultSet); ok {
		r0 = rf(args, q)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*db.ResultSet)
		}
	}

	var r1 *db.JaxDbError
	if rf, ok := ret.Get(1).(func(map[string]interface{}, query.SearchQuery) *db.JaxDbError); ok {
		r1 = rf(args, q)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*db.JaxDbError)
		}
	}

	return r0, r1
}

var _ db.JaxReader = (*JaxReader)(nil)
