package mocks

import "code.justin.tv/web/jax/db"
import "github.com/stretchr/testify/mock"

// JaxWriter is an autogenerated mock type for the JaxWriter type
type JaxWriter struct {
	mock.Mock
}

// CreateIndexIfNotExists provides a mock function with given fields: shards, replicas
func (_m *JaxWriter) CreateIndexIfNotExists(shards int, replicas int) *db.JaxDbError {
	ret := _m.Called(shards, replicas)

	var r0 *db.JaxDbError
	if rf, ok := ret.Get(0).(func(int, int) *db.JaxDbError); ok {
		r0 = rf(shards, replicas)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*db.JaxDbError)
		}
	}

	return r0
}

// Delete provides a mock function with given fields: channel
func (_m *JaxWriter) Delete(channel string) {
	_m.Called(channel)
}

// Update provides a mock function with given fields: channel, input
func (_m *JaxWriter) Update(channel string, input map[string]interface{}) *db.JaxDbError {
	ret := _m.Called(channel, input)

	var r0 *db.JaxDbError
	if rf, ok := ret.Get(0).(func(string, map[string]interface{}) *db.JaxDbError); ok {
		r0 = rf(channel, input)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*db.JaxDbError)
		}
	}

	return r0
}
