package query

import (
	"encoding/json"

	"code.justin.tv/web/jax/common/log"
)

type scanQuery struct {
	Query struct {
		Filtered struct {
			And struct {
				Filters []Filter `json:"and,omitempty"`
			} `json:"filter"`
		} `json:"filtered"`
	} `json:"query"`
}

// ScanQuery converts an array of filters into a raw query that will return a collection of channels.
func ScanQuery(filters []Filter) []byte {
	q := &scanQuery{}

	q.Query.Filtered.And.Filters = filters

	bytes, err := json.Marshal(q)
	if err != nil {
		log.Reportf("could not marshal the broker query: %v\n", err)
	}
	return bytes
}
