package query

import (
	"testing"

	. "github.com/smartystreets/goconvey/convey"
)

func TestScanQuery(t *testing.T) {
	Convey("with filters", t, func() {
		testField := "sdfdsf"
		b := ScanQuery([]Filter{ExistsFieldFilter(testField)})

		So(string(b), ShouldContainSubstring, testField)
	})

	Convey("without filters", t, func() {
		b := ScanQuery([]Filter{})

		So(string(b), ShouldNotContainSubstring, "null")
	})
}
