package query

import (
	"encoding/json"
	"time"
)

type randomSortSearchQuery struct {
	From   int      `json:"from,omitempty"`
	Size   int      `json:"size"`
	Fields []string `json:"_source,omitempty"`
	Query  struct {
		FunctionScore functionScore `json:"function_score"`
	} `json:"query"`
}

type functionScore struct {
	Filters struct {
		And []Filter `json:"and,omitempty"`
	} `json:"filter,omitempty"`

	RandomScore struct {
		Seed int64 `json:"seed"`
	} `json:"random_score"`
}

func RandomSortSearchQuery(limit, offset int, fields []string, filters []Filter) []byte {
	q := &randomSortSearchQuery{}
	q.Size = limit
	if q.Size <= 0 {
		q.Size = 100
	}
	q.From = offset
	q.Fields = fields

	q.Query.FunctionScore.RandomScore.Seed = time.Now().Unix()
	q.Query.FunctionScore.Filters.And = append([]Filter{ExistsFieldFilter("usher.channel_count")}, filters...)

	b, err := json.Marshal(q)
	if err != nil {
		return []byte{}
	}
	return b
}
