package query

import (
	"testing"
	"time"

	. "github.com/smartystreets/goconvey/convey"
)

func TestRandomSearchQuery(t *testing.T) {
	Convey("query changes every call", t, func() {
		b := RandomSortSearchQuery(10, 0, nil, []Filter{})

		time.Sleep(1 * time.Second)

		b2 := RandomSortSearchQuery(10, 0, nil, []Filter{})

		So(string(b), ShouldNotEqual, string(b2))
	})

	Convey("defaults to 100 size if limit is nonpositive", t, func() {
		b := RandomSortSearchQuery(-1, 0, nil, []Filter{})

		So(string(b), ShouldContainSubstring, "size")
		So(string(b), ShouldContainSubstring, "100")
	})
}
