 #!/bin/sh

echo "Downloading Sandstorm-Agent"
aws s3 cp s3://twitch-sandstorm/sandstorm-agent.rpm /tmp/sandstorm-agent.rpm || (echo "Failed to download sandstorm-agent.rpm, do you have the correct permissions?" && exit 1)

yum install -y /tmp/sandstorm-agent.rpm || (echo "No package available" && exit 1)

eval  $(/opt/elasticbeanstalk/containerfiles/support/generate_env | sed 's/$/;/')

source /var/app/config-${ENVIRONMENT}.sh

# Replaces ENVIRONMENT with $ENVIRONMENT environment variable
sed -i "s/{ENVIRONMENT}/${ENVIRONMENT}/g" /etc/sandstorm-agent/templates.d/*
sed -i "s/{ENVIRONMENT}/$ENVIRONMENT/g" /etc/sandstorm-agent/conf.d/*.conf

# Environment variables substitution
sed -i "s|{ES_HOST}|${ES_HOST}|g" /etc/sandstorm-agent/templates.d/*
sed -i "s|{ES_HOST}|$ES_HOST|g" /etc/sandstorm-agent/conf.d/*.conf

sed -i "s|{ZUMA_HOST}|${ZUMA_HOST}|g" /etc/sandstorm-agent/templates.d/*
sed -i "s|{ZUMA_HOST}|$ZUMA_HOST|g" /etc/sandstorm-agent/conf.d/*.conf

sed -i "s|{DEEPMETADATA_HOST}|${DEEPMETADATA_HOST}|g" /etc/sandstorm-agent/templates.d/*
sed -i "s|{DEEPMETADATA_HOST}|$DEEPMETADATA_HOST|g" /etc/sandstorm-agent/conf.d/*.conf

sed -i "s|{KINESIS_INDEX}|${KINESIS_INDEX}|g" /etc/sandstorm-agent/templates.d/*
sed -i "s|{KINESIS_INDEX}|$KINESIS_INDEX|g" /etc/sandstorm-agent/conf.d/*.conf

sed -i "s|{LANGUAGE_CCU_KINESIS}|${LANGUAGE_CCU_KINESIS}|g" /etc/sandstorm-agent/templates.d/*
sed -i "s|{LANGUAGE_CCU_KINESIS}|$LANGUAGE_CCU_KINESIS|g" /etc/sandstorm-agent/conf.d/*.conf

echo "Setting Up Monit"

mkdir -p /var/lib/monit

monit
sleep 5
monit reload
sleep 5

echo "Restarting Sandstorm-Agent"
monit restart sandstorm-agent

# Clean Up

