Jax
======
Jax holds data from different sources about streams which are currently online. It is the driving
force behind the directory listing and the live streams API endpoint.

API
---
Staging: [jax-internal-staging.us-west2.justin.tv](jax-internal-staging.us-west2.justin.tv)  
Production: [jax-internal-production.us-west2.justin.tv](jax-internal-production.us-west2.justin.tv)  

Jax knows the following internally accessible endpoints:

### GET /stream:  
Returns a single stream's info, if the stream is live.

Parameters:

    fields: fields that this stream must have
    live: if false, only returns the stream if it is a playlist
    channel or id: identification of the channel

Example:

    curl -XGET 'localhost:6062/stream?channel=kaidencenl&fields=usher.channel_count'

    {
        "_total": 1,
        "hits": [
            {
                "channel": "kaidencenl",
                "properties": {
                    "usher": {
                        "channel_count": 34
                    }
                }
            }
        ]
    }

### GET/POST /stream/list:  
Returns a list of streams.

Parameters:

    size: The number of results to return. Default=20.
    from: The offset from which to return results. Default=0.
    fields: fields that this stream must have
    stream_type=(live,all,playlist): used for filtering streams that are live or playlists or both
    xbox_heartbeat=(true,false): used for filtering streams that have xbox_heartbeat
    channels or channel_ids: identification of the channels

also accepts equality filters in the form:

    usher.broadcaster=octodad,candybox

This endpoint requires either a channels or channel_ids paramter which are comma-separated lists of channel names or channel ids. These can be passed in as either a url parameter (GET) or url-encoded form parameter (POST).

Example:

    curl -XPOST 'localhost:6062/stream/list?usher.broadcaster=obs&fields=usher.broadcaster,usher.channel_count' -d 'channels=foo,bar,baz'

Example response:

    {
        "_total": 2,
        "hits": [
            {
                "channel": "foo",
                "properties": {
                    "usher": {
                        "broadcaster": "obs",
                        "channel_count": 345
                    }
                }
            },
            {
                "channel": "baz",
                "properties": {
                    "usher": {
                        "broadcaster": "obs",
                        "channel_count": 64
                    }
                }
            }
        ]
    }

### GET/POST /streams:  
Returns a list of current livestreams based on the parameters and request body. Accepted URL parameters:

    from: The offset from which to return results. Default=0.
    size: The number of results to return. Default=20.
    sort: A single field to sort on. Default=usher.channel_count.
    direction: 'asc' or 'desc' to determine the sorting direction. Default=desc.

For a GET, /streams accepts equality filters in the form:

    usher.broadcaster=octodad,candybox

and other special filters

    stream_type=(live,all,playlist): used for filtering streams that are live or playlists or both
    xbox_heartbeat=(true,false): used for filtering streams that have xbox_heartbeat

For a POST, /streams can take a post body to further query through the current live streams. In the body, it is possible to specify:

    { "fields" : ["fieldname1", "fieldname2", "fieldname3"] }

    { "filter" : { filter_name : query } } where the possible filters are:
        { "exists" : fieldname }
        { "eq" : { fieldname : value(s) } }
        { "gt"/"gte"/"lt"/"lte" : { fieldname : value } }
        { "and"/"or" : [filter1, filter2] }
        { "not": filter }

Example #1:

    curl -XGET 'localhost:6062/streams?from=20&size=1&sort=usher.video_bitrate&direction=asc&rails.meta_game=Dota 2'

Example result:

    {
        "_total": 11222,
        "hits" : [
            {
                "channel" : "kaidencenl",
                "properties": {
                    "rails" : {
                        "meta_game" : "Dota 2",
                        ...
                    },
                    "usher" : {
                        "broadcaster" : "obs",
                        ...
                        "video_bitrate" : 0,
                    }
                }
            }
        ]
    }

Example #2:

    curl -XPOST localhost:6062/streams?size=2 -d `
        {
            "fields" : ["usher.channel_count", "csgo", "rails"],
            "filter" : {
                "or" : [
                    { "exists" : "csgo" },
                    { "and" : [
                        { "eq" : { "rails.meta_game" : "Counter-Strike: Global Offensive" } },
                        { "gt" : { "usher.channel_count" : 2000 } }
                    ]}
                ]
            }
        }
    `

Example result:

    {
        "_total": 23,
        "hits" : [
            {
                "channel" : "shootmcfacey",
                "properties" : {
                    "usher" : {
                        "channel_count" : 123
                    },
                    "csgo" : {
                        "map" : "de_dust2",
                        ...
                    },
                    "rails" : {
                        "meta_game" : Counter-Strike: Global Offensive",
                        ...
                    }
                }
            }
        ]
    }

### GET /stream/summary:  

Returns aggregations of channel and viewer counts, sorted by total viewer count.

Acceptable parameters:
    
    size: Limit number of buckets returned
    group-by: Bucket aggregations by a field.
    sort: Sort by a different field than summary viewers
    include-sort-value: "true" to include the value used for sorting in the response object


Also accepts equality filters of the form

    usher.broadcaster=octodad,candybox

Example: 

    curl -XGET 'stream/summary?size=2&group-by=rails.game_id&usher.broadcaster=octodad,candybox'

Example response:

    {
        "results": [
            {
                "channels": 1453,
                "rails.game_id": 489401,
                "viewers": 4727
            },
            {
                "channels": 792,
                "rails.game_id": 488552,
                "viewers": 4513
            }
        ]
    }
