Jax Infrastructure
======
Jax has a complicated architecture and many dependencies. This documents describes it at a high level.

Processes
---
Jax has two main processes: API and updater.

The API process handles HTTP requests and reads data from ES. The functionality is documented [here](https://git-aws.internal.justin.tv/web/jax/blob/master/doc/api.md).

The updater process is responsible for adding and removing live streams from ES, and updating their properties. This process is complicated enough to warrant its own section.

A process called gor is also run alongside Jax. gor listens to the inbound HTTP traffic to Jax and replicates a portion of it to our staging environment to act as a smoke test.

Updater Process
---
The updater consists of two parts: a liveness portion that takes care of adding/removing streams and a property updater.

The liveness updater polls usher for the list of live streams and upserts every stream that usher returns. This sets the `streamlist.last_updated` field to the current time for all the streams that are live. It then retrieves the list of streams from ES that are expired (`streamlist.last_updated` older than some time), and deletes those streams from ES.

The properties updaters constantly scans through the streams in ES and updates their properties using several data sources. These sources currently include rails (api.internal), usher, channels service, valve api, and microsoft api. Chunks of streams are processed at a time: for each property source the chunk is filtered into a subchunk of streams that need an update from that property source. The required properties are retrieved from the respective property sources, merged with the existing properties for the chunk of streams, and written back into ES.

The updater process only runs on one Jax machine at a time. This is achieved by running the updater process inside a `consul lock`, which will block concurrent execution of the child process using a key stored in consul.

Infrastructure
---
Jax runs on EC2 instances in an ASG behind an ELB in twitch-web-aws. The ASG is configured in terraform and the EC2 instances are puppetized.

Jax's ES cluster is AWS Elasticsearch Service. Jax is capable of running on two clusters at once, with both clusters kept in sync by the updater and reads split between the two clusters. This is how Jax is run in production currently because of networking limits on a single AWS ES cluster. The AWS ES clusters are managed by terraform.

Jax also has a production-canary environment, which is a single box that has a separate updater group than the other production boxes, allowing it to run its own updater process. It updates its own ES cluster, while the canary API process reads from the same ES cluster(s) as the other production boxes. This allows for testing of the updater on canary without affecting the rest of production.

Jax's staging environment is in twitch-web-dev, configured in the same way as production.

Infrastructure Updates
---
To make modifications to Jax's infrastructure, only terraform needs to be updated and run. The terraform version used to create Jax resourses is 0.9.4.
