job {
    name "web-jax"
    using 'TEMPLATE-autobuild'
    scm {
        git {
            remote {
                github 'web/jax', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }
    steps {
        // Build for master
        shell 'rm -rf .manta/'
        shell 'manta -v -proxy'
        saveDirtyDeployArtifact 'web/jax', '.manta'
        saveDeployArtifact 'web/jax', '.manta'

        shell 'rm -rf .manta/'
        shell 'manta -v -proxy -f build.json'
        saveDirtyDeployArtifact 'web/jax-eb', '.manta'
        saveDeployArtifact 'web/jax-eb', '.manta'

        // TODO: Choose the correct EB extensions file for api
        shell 'docker build -t docker-registry.internal.justin.tv/web-jax-api:$GIT_COMMIT -f ./api/Dockerfile .'
        shell 'docker push docker-registry.internal.justin.tv/web-jax-api:$GIT_COMMIT'
        saveDeployArtifact 'web/jax-api-ebextensions', 'deploy'

        // TODO: Choose the correct EB extensions file for updater
        shell 'docker build -t docker-registry.internal.justin.tv/web-jax-updater:$GIT_COMMIT -f ./updater/Dockerfile .'
        shell 'docker push docker-registry.internal.justin.tv/web-jax-updater:$GIT_COMMIT'
        saveDeployArtifact 'web/jax-updater-ebextensions', 'deploy'
    }
}

job {
    name 'web-jax-deploy'
    using 'TEMPLATE-deploy'
    steps {
        shell 'courier deploy --repo web/jax --dir /home/jtv/jax_deploy'
    }
}

freeStyleJob('web-jax-deploy-staging') {
    using 'TEMPLATE-deploy-aws'
    steps {
        shell 'courier deploy --repo web/jax --dir /home/jtv/jax_deploy'
    }
}

freeStyleJob('web-jax-deploy-canary') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'RUNSCOPE_TOKEN', 'JAX_RUNSCOPE_TOKEN'
        }
    }

    steps {
        downloadDeployArtifact 'web/jax'
        shell 'courier deploy --repo web/jax --dir /home/jtv/jax_deploy'

        shell 'sleep 60' // Wait some amount of time before checking status
        shell 'RUNSCOPE_TOKEN=\$RUNSCOPE_TOKEN bin/runscope' // run Runscope integration tests against canary
    }
}

freeStyleJob('web-jax-deploy-production') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'RUNSCOPE_TOKEN', 'JAX_RUNSCOPE_TOKEN'
        }
    }

    steps {
        downloadDeployArtifact 'web/jax'
        shell 'courier deploy --repo web/jax --dir /home/jtv/jax_deploy --hosts $(consul-search -deploy -services jax-nginx -tag clean-production-canary)'
        shell 'sleep 60' // Wait some amount of time before checking status
        shell 'RUNSCOPE_TOKEN=\$RUNSCOPE_TOKEN bin/runscope' // run Runscope integration tests against canary

        conditionalSteps {
            condition {
                status('SUCCESS', 'SUCCESS')
            }
            runner('Fail')
            steps {
                shell 'courier deploy --repo web/jax --dir /home/jtv/jax_deploy'
            }
        }
    }
}

freeStyleJob('web-jax-deploy-production-api') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-discovery-aws-access-key'
            string 'AWS_SECRET_KEY', 'twitch-discovery-aws-secret-key'
        }
    }

    steps {
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'web/jax-api-ebextensions'
        shell 'rm *.manifest*'
        // deploy api
        shell """pip install awsebcli >/dev/null
                |set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |export PYTHONUNBUFFERED=1
                |set -x
                |export IMAGE=docker-registry.internal.justin.tv/web-jax-api:\$GIT_COMMIT
                |
                |cat <<EOF > Dockerrun.aws.json
                |{
                |  "AWSEBDockerrunVersion": "1",
                |  "Image": {
                |    "Name": "\$IMAGE",
                |    "Update": "false"
                |  },
                |  "Ports": [
                |    {
                |      "HostPort": "80",
                |      "ContainerPort": "6062"
                |    },
                |    {
                |      "HostPort": "9200",
                |      "ContainerPort": "9200"
                |    }
                |  ],
                |  "Volumes": [
                |    {
                |      "ContainerDirectory": "/etc/ssl/certs/ca-bundle.crt",
                |      "HostDirectory": "/etc/ssl/certs/ca-bundle.crt"
                |    },
                |    {
                |       "ContainerDirectory": "/var/app",
                |       "HostDirectory": "/var/app"
                |    },
                |    {
                |       "ContainerDirectory": "/usr/share/elasticsearch/data",
                |       "HostDirectory": "/usr/share/elasticsearch/data"
                |    }
                |  ],
                |  "Logging": "/var/log/"
                |}
                |EOF
                |
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2
                | eb deploy jax-production-api""".stripMargin()
    }
}

freeStyleJob('web-jax-deploy-production-updater') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-discovery-aws-access-key'
            string 'AWS_SECRET_KEY', 'twitch-discovery-aws-secret-key'
        }
    }

    steps {
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'web/jax-updater-ebextensions'
        shell 'rm *.manifest*'
        // deploy updater
        shell """pip install awsebcli >/dev/null
                |set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |export PYTHONUNBUFFERED=1
                |set -x
                |export IMAGE=docker-registry.internal.justin.tv/web-jax-updater:\$GIT_COMMIT
                |
                |cat <<EOF > Dockerrun.aws.json
                |{
                |  "AWSEBDockerrunVersion": "1",
                |  "Image": {
                |    "Name": "\$IMAGE",
                |    "Update": "false"
                |  },
                |  "Ports": [
                |    {
                |      "HostPort": "80",
                |      "ContainerPort": "6065"
                |    }
                |  ],
                |  "Volumes": [
                |    {
                |      "ContainerDirectory": "/etc/ssl/certs/ca-bundle.crt",
                |      "HostDirectory": "/etc/ssl/certs/ca-bundle.crt"
                |    },
                |    {
                |       "ContainerDirectory": "/var/app",
                |       "HostDirectory": "/var/app"
                |    }
                |  ],
                |  "Logging": "/var/log/"
                |}
                |EOF
                |
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2
                | eb deploy jax-production-updater""".stripMargin()
    }
}


freeStyleJob('web-jax-deploy-canary-api') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-discovery-aws-access-key'
            string 'AWS_SECRET_KEY', 'twitch-discovery-aws-secret-key'
        }
    }

    steps {
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'web/jax-api-ebextensions'
        shell 'rm *.manifest*'
        // deploy api
        shell """pip install awsebcli >/dev/null
                |set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |export PYTHONUNBUFFERED=1
                |set -x
                |export IMAGE=docker-registry.internal.justin.tv/web-jax-api:\$GIT_COMMIT
                |
                |cat <<EOF > Dockerrun.aws.json
                |{
                |  "AWSEBDockerrunVersion": "1",
                |  "Image": {
                |    "Name": "\$IMAGE",
                |    "Update": "false"
                |  },
                |  "Ports": [
                |    {
                |      "HostPort": "80",
                |      "ContainerPort": "6062"
                |    },
                |    {
                |      "HostPort": "9200",
                |      "ContainerPort": "9200"
                |    }
                |  ],
                |  "Volumes": [
                |    {
                |      "ContainerDirectory": "/etc/ssl/certs/ca-bundle.crt",
                |      "HostDirectory": "/etc/ssl/certs/ca-bundle.crt"
                |    },
                |    {
                |       "ContainerDirectory": "/var/app",
                |       "HostDirectory": "/var/app"
                |    },
                |    {
                |       "ContainerDirectory": "/usr/share/elasticsearch/data",
                |       "HostDirectory": "/usr/share/elasticsearch/data"
                |    }
                |  ],
                |  "Logging": "/var/log/"
                |}
                |EOF
                |
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2
                | eb deploy jax-canary-api""".stripMargin()
    }
}
freeStyleJob('web-jax-deploy-canary-updater') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-discovery-aws-access-key'
            string 'AWS_SECRET_KEY', 'twitch-discovery-aws-secret-key'
        }
    }

    steps {
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'web/jax-updater-ebextensions'
        shell 'rm *.manifest*'
        // deploy updater
        shell """pip install awsebcli >/dev/null
                |set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |export PYTHONUNBUFFERED=1
                |set -x
                |export IMAGE=docker-registry.internal.justin.tv/web-jax-updater:\$GIT_COMMIT
                |
                |cat <<EOF > Dockerrun.aws.json
                |{
                |  "AWSEBDockerrunVersion": "1",
                |  "Image": {
                |    "Name": "\$IMAGE",
                |    "Update": "false"
                |  },
                |  "Ports": [
                |    {
                |      "HostPort": "80",
                |      "ContainerPort": "6065"
                |    }
                |  ],
                |  "Volumes": [
                |    {
                |      "ContainerDirectory": "/etc/ssl/certs/ca-bundle.crt",
                |      "HostDirectory": "/etc/ssl/certs/ca-bundle.crt"
                |    },
                |    {
                |       "ContainerDirectory": "/var/app",
                |       "HostDirectory": "/var/app"
                |    }
                |  ],
                |  "Logging": "/var/log/"
                |}
                |EOF
                |
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2
                | eb deploy jax-canary-updater""".stripMargin()
    }
}

freeStyleJob('web-jax-deploy-staging-api') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-discovery-aws-access-key'
            string 'AWS_SECRET_KEY', 'twitch-discovery-aws-secret-key'
        }
    }

    steps {
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'web/jax-api-ebextensions'
        shell 'rm *.manifest*'
        // deploy api
        shell """pip install awsebcli >/dev/null
                |set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |export PYTHONUNBUFFERED=1
                |set -x
                |export IMAGE=docker-registry.internal.justin.tv/web-jax-api:\$GIT_COMMIT
                |
                |cat <<EOF > Dockerrun.aws.json
                |{
                |  "AWSEBDockerrunVersion": "1",
                |  "Image": {
                |    "Name": "\$IMAGE",
                |    "Update": "false"
                |  },
                |  "Ports": [
                |    {
                |      "HostPort": "80",
                |      "ContainerPort": "6062"
                |    },
                |    {
                |      "HostPort": "9200",
                |      "ContainerPort": "9200"
                |    }
                |  ],
                |  "Volumes": [
                |    {
                |      "ContainerDirectory": "/etc/ssl/certs/ca-bundle.crt",
                |      "HostDirectory": "/etc/ssl/certs/ca-bundle.crt"
                |    },
                |    {
                |       "ContainerDirectory": "/var/app",
                |       "HostDirectory": "/var/app"
                |    },
                |    {
                |       "ContainerDirectory": "/usr/share/elasticsearch/data",
                |       "HostDirectory": "/usr/share/elasticsearch/data"
                |    }
                |  ],
                |  "Logging": "/var/log/"
                |}
                |EOF
                |
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2
                | eb deploy jax-staging-api""".stripMargin()
    }
}
freeStyleJob('web-jax-deploy-staging-updater') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-discovery-aws-access-key'
            string 'AWS_SECRET_KEY', 'twitch-discovery-aws-secret-key'
        }
    }

    steps {
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'web/jax-updater-ebextensions'
        shell 'rm *.manifest*'
        // deploy updater
        shell """pip install awsebcli >/dev/null
                |set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |export PYTHONUNBUFFERED=1
                |set -x
                |export IMAGE=docker-registry.internal.justin.tv/web-jax-updater:\$GIT_COMMIT
                |
                |cat <<EOF > Dockerrun.aws.json
                |{
                |  "AWSEBDockerrunVersion": "1",
                |  "Image": {
                |    "Name": "\$IMAGE",
                |    "Update": "false"
                |  },
                |  "Ports": [
                |    {
                |      "HostPort": "80",
                |      "ContainerPort": "6065"
                |    }
                |  ],
                |  "Volumes": [
                |    {
                |      "ContainerDirectory": "/etc/ssl/certs/ca-bundle.crt",
                |      "HostDirectory": "/etc/ssl/certs/ca-bundle.crt"
                |    },
                |    {
                |       "ContainerDirectory": "/var/app",
                |       "HostDirectory": "/var/app"
                |    }
                |  ],
                |  "Logging": "/var/log/"
                |}
                |EOF
                |
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v --region us-west-2
                | eb deploy jax-staging-updater""".stripMargin()
    }
}
