package main

import (
	"math"
	"math/rand"
	"strconv"
	"strings"
	"time"
)

func getTime(unixtime float64) time.Time {
	seconds, fractionalSeconds := math.Modf(unixtime)
	nanos := fractionalSeconds * 1000000000
	t := time.Unix(int64(seconds), int64(nanos)).UTC()
	return t
}

func randomDuration(min, max int64, units time.Duration) time.Duration {
	src := rand.NewSource(time.Now().UnixNano())
	r := rand.New(src)

	return time.Duration(min+r.Int63n((max-min)+1)) * units
}

func roundToMs(d time.Duration) time.Duration {
	ms := int64(d.Nanoseconds() / 1000000)
	return time.Duration(ms * 1000000)
}

// time.Since() rounded to milliseconds.
func since(t time.Time) time.Duration {
	return roundToMs(time.Since(t))
}

func elapsed(startEpoch, endEpoch float64) time.Duration {
	start, end := getTime(startEpoch), getTime(endEpoch)
	d := end.Sub(start)
	return roundToMs(d)
}

func getStatusCode(err error) int {
	errStr := err.Error()
	if !strings.Contains(errStr, "did not match 2xx") {
		return 0
	}

	statusCode, convErr := strconv.Atoi(errStr[len(errStr)-3:])
	if convErr != nil {
		return 0
	}

	return statusCode
}
