package main

import (
	"errors"
	"testing"
)

var getStatusCodeCases = []struct {
	err  error
	code int
}{
	{errors.New("Request did not match 2xx: 504"), 504},
	{errors.New("Request did not match 2xx: 404"), 404},
	{errors.New("Request did not match 2xx: monkeys"), 0},
	{errors.New("Unable to unmarshal json: {}"), 0},
}

func TestGetStatusCode(t *testing.T) {
	for _, test := range getStatusCodeCases {
		actual := getStatusCode(test.err)
		if actual != test.code {
			t.Errorf("getStatusCode(%v) wanted: %d, actual: %d", test.err, test.code, actual)
		}
	}
}
