#!/bin/bash

set -e

ACCOUNT=$1

case "$ACCOUNT" in
        elasticbeanstalk)
            ENVIRONMENTS=(dev)
            ;;
        *)
            echo "Unknown account \"$ACCOUNT\", exiting"
            exit 1
esac

cd ./terraform/${ACCOUNT}

for ENVIRONMENT in "${ENVIRONMENTS[@]}"
do
    ROLE=`terraform output ${ENVIRONMENT}-iam_role_arn`

    tcs sandstorm role-flags \
        --owner team-search-discovery \
        --name search-discovery-${ENVIRONMENT}-jax \
        --secret_key "search-discovery/jax/${ENVIRONMENT}/*" \
        --allowed_arn "${ROLE}" \
        --output ./sandstorm.d/${ACCOUNT}_${ENVIRONMENT}.json

done
