# twitch-web-aws state
resource "terraform_remote_state" "twitch_web_aws" {
  backend = "s3"
  config {
    bucket = "twitch-web-aws"
    key = "tfstate/web/terraform/accounts/twitch-web-aws"
    region = "us-west-2"
  }
}

module "instance" {
  source = "../aws_es_instance"
  name = "jax-canary"
  es_instance_count = 7
  es_instance_type = "r3.8xlarge.elasticsearch"
  es_resource = "arn:aws:es:us-west-2:641044725657:domain/jax-canary/*"
  es_ip_whitelist = "38.104.129.210,${terraform_remote_state.twitch_web_aws.output.nat_gw_a_public_ip},${terraform_remote_state.twitch_web_aws.output.nat_gw_b_public_ip},${terraform_remote_state.twitch_web_aws.output.nat_gw_c_public_ip}"
}