provider "aws" {
  region = "us-west-2"
}

variable "name" {}
variable "es_resource" {}

variable "es_instance_count" {
  default = 2
}
variable "es_instance_type" {
  default = "m3.medium.elasticsearch"
}
variable "es_master_count" {
  default = 3
}
variable "es_master_type" {
  default = "m3.medium.elasticsearch"
}
variable "es_ip_whitelist" {
  default = "38.104.129.210"
  description = "Comma-delimited list of IPs or CIDRs that are whitelisted to access the ElasticSearch cluster"
}

# All of these commads take considerable time (minutes) to run because of
# the wait for AWS to change state for each ElasticSearch Domain
# https://www.terraform.io/docs/providers/aws/r/elasticsearch_domain.html
resource "aws_elasticsearch_domain" "es" {
  domain_name = "${var.name}"
  cluster_config {
    instance_type = "${var.es_instance_type}"
    instance_count = "${var.es_instance_count}"
    dedicated_master_enabled = "true"
    dedicated_master_count = "${var.es_master_count}"
    dedicated_master_type = "${var.es_master_type}"
  }
  access_policies = <<ACCESS_POLICIES
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Principal": {
        "AWS": "*"
      },
      "Action": "es:*",
      "Resource": "${var.es_resource}",
      "Condition": {
        "IpAddress": {
          "aws:SourceIp": ["${join("\",\"", split(",", var.es_ip_whitelist))}"]
        }
      }
    }
  ]
}
ACCESS_POLICIES
}
