

module "bs-clean-staging" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "twitch-discovery-aws"
  aws_region = "us-west-2"
  eb_application_name = "${module.bs-app-elasticbeanstalk.beanstalk_application_name}"
  vpc_id = "vpc-15e70b72"
  ec2_subnet_ids = "subnet-f08d8694,subnet-8fae83f9,subnet-df3ea487"
  elb_subnet_ids = "subnet-f08d8694,subnet-8fae83f9,subnet-df3ea487"
  elb_loadbalancer_security_groups = "sg-8b58c6f2"
  auto_scaling_lc_security_groups = "sg-8b58c6f2"
  solution_stack_name = "64bit Amazon Linux 2017.03 v2.7.1 running Docker 17.03.1-ce"
  auto_scaling_lc_instance_type = "c4.large"
  owner = "mpaldhe@twitch.tv"
  service = "web/jax"
  env = "clean-staging"
  associate_public_address = "false"

}
