resource "aws_sns_topic" "pagerduty_alarm" {
  name = "Search-Discovery-OnCall"
}

resource "aws_cloudwatch_metric_alarm" "app-cpu" {
  alarm_name = "${var.name}-${var.environment}-app-cpu"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "5"
  metric_name = "CPUUtilization"
  namespace = "AWS/EC2"
  period = "60"
  statistic = "Average"
  threshold = "50"
  dimensions = {AutoScalingGroupName = "${aws_autoscaling_group.app_asg.id}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
  ok_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}

resource "aws_cloudwatch_metric_alarm" "app-status" {
  alarm_name = "${var.name}-${var.environment}-app-status"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "3"
  metric_name = "StatusCheckFailed"
  namespace = "AWS/EC2"
  period = "60"
  statistic = "Average"
  threshold = "1"
  dimensions = {AutoScalingGroupName = "${aws_autoscaling_group.app_asg.id}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
  insufficient_data_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}

resource "aws_cloudwatch_metric_alarm" "canary-app-cpu" {
  alarm_name = "${var.name}-${var.environment}-canary-app-cpu"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "5"
  metric_name = "CPUUtilization"
  namespace = "AWS/EC2"
  period = "60"
  statistic = "Average"
  threshold = "50"
  dimensions = {AutoScalingGroupName = "${aws_autoscaling_group.canary_app_asg.id}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
  insufficient_data_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
  ok_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}

resource "aws_cloudwatch_metric_alarm" "canary-app-status" {
  alarm_name = "${var.name}-${var.environment}-canary-app-status"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "3"
  metric_name = "StatusCheckFailed"
  namespace = "AWS/EC2"
  period = "60"
  statistic = "Average"
  threshold = "1"
  dimensions = {AutoScalingGroupName = "${aws_autoscaling_group.canary_app_asg.id}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
  insufficient_data_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
  ok_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}

resource "aws_cloudwatch_metric_alarm" "elb_unhealthy_hosts" {
  alarm_name = "${var.name}_unhealthy_hosts"
  comparison_operator = "GreaterThanThreshold"
  evaluation_periods = "5"
  metric_name = "UnHealthyHostCount"
  namespace = "AWS/ELB"
  period = "60"
  statistic = "Maximum"
  threshold = "0"
  dimensions = {LoadBalancerName = "${aws_elb.internal_app_elb.name}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
  insufficient_data_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}

resource "aws_cloudwatch_metric_alarm" "elb_backend_conn_error" {
  alarm_name = "${var.name}_backend_conn_error"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "5"
  metric_name = "BackendConnectionErrors"
  namespace = "AWS/ELB"
  period = "60"
  statistic = "Sum"
  threshold = "0"
  dimensions = {LoadBalancerName = "${aws_elb.internal_app_elb.name}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
  insufficient_data_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}

resource "aws_cloudwatch_metric_alarm" "elb_http_4xx" {
  alarm_name = "${var.name}_http_4xx"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "5"
  metric_name = "HTTPCode_Backend_4XX"
  namespace = "AWS/ELB"
  period = "60"
  statistic = "Sum"
  threshold = "1000"
  dimensions = {LoadBalancerName = "${aws_elb.internal_app_elb.name}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
  insufficient_data_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
  ok_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}

resource "aws_cloudwatch_metric_alarm" "elb_http_5xx" {
  alarm_name = "${var.name}_http_5xx"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "5"
  metric_name = "HTTPCode_Backend_5XX"
  namespace = "AWS/ELB"
  period = "60"
  statistic = "Sum"
  threshold = "1000"
  dimensions = {LoadBalancerName = "${aws_elb.internal_app_elb.name}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
  insufficient_data_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
  ok_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}

resource "aws_cloudwatch_metric_alarm" "elb_elb_4xx" {
  alarm_name = "${var.name}_elb_4xx"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "5"
  metric_name = "HTTPCode_ELB_4XX"
  namespace = "AWS/ELB"
  period = "60"
  statistic = "Sum"
  threshold = "1000"
  dimensions = {LoadBalancerName = "${aws_elb.internal_app_elb.name}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
  ok_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}

resource "aws_cloudwatch_metric_alarm" "elb_elb_5xx" {
  alarm_name = "${var.name}_elb_5xx"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "5"
  metric_name = "HTTPCode_ELB_5XX"
  namespace = "AWS/ELB"
  period = "60"
  statistic = "Sum"
  threshold = "1000"
  dimensions = {LoadBalancerName = "${aws_elb.internal_app_elb.name}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
  ok_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}

resource "aws_cloudwatch_metric_alarm" "elb_latency" {
  alarm_name = "${var.name}_latency"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "5"
  metric_name = "Latency"
  namespace = "AWS/ELB"
  period = "60"
  statistic = "Average"
  threshold = "0.5"
  dimensions = {LoadBalancerName = "${aws_elb.internal_app_elb.name}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
  ok_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}

resource "aws_cloudwatch_metric_alarm" "elb_spillover" {
  alarm_name = "${var.name}_spillover"
  comparison_operator = "GreaterThanThreshold"
  evaluation_periods = "5"
  metric_name = "SpilloverCount"
  namespace = "AWS/ELB"
  period = "60"
  statistic = "Sum"
  threshold = "0"
  dimensions = {LoadBalancerName = "${aws_elb.internal_app_elb.name}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
  insufficient_data_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}

resource "aws_cloudwatch_metric_alarm" "elb_surge" {
  alarm_name = "${var.name}_surge"
  comparison_operator = "GreaterThanThreshold"
  evaluation_periods = "5"
  metric_name = "SurgeQueueLength"
  namespace = "AWS/ELB"
  period = "60"
  statistic = "Maximum"
  threshold = "500"
  dimensions = {LoadBalancerName = "${aws_elb.internal_app_elb.name}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
  insufficient_data_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
  ok_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}
