# Service name used for AWS tagging among other things
variable "name" {}

# DNS safe service name
variable "hostname" {}

# Domain
variable "domain" {
    default = {
        "production-aws" = "prod.us-west2.justin.tv"
        "production-loadtest" = "prod.us-west2.justin.tv"
        "production" = "prod.us-west2.justin.tv"
        "staging" = "dev.us-west2.justin.tv"
    }
}

# AWS Account
variable "account" {
    default = {
        "production-aws" = "twitch-web-aws"
        "production-loadtest" = "twitch-web-aws"
        "production" = "twitch-web-aws"
        "staging" = "twitch-web-dev"
    }
}

# Team email alias
variable "owner" {}

# Project name, usually git repo. ex. dta/twitch-create-service
variable "project" {}

# EC2 Instance Image
variable "ami" {
  default = "ami-dd11f3bd"
}

# EC2 Instance Type
variable "instance_type" {
  default = "c4.large"
}

# Largest a service cluster will grow to
variable "max_size" {
  default = 0
}

# Smallest a service cluster will shrink down to
variable "min_size" {
  default = 0
}

# Number of canary instances
variable "canary_size" {
  default = 0
}

# Service environment
variable "environment" {}

# Amount of diskspace allocated to the root drive. (GB)
variable "root_volume_size" {
  default = 256
}

# Service role for controlling access to other AWS services
variable "iam_role_name" {
  default = "jax"
}

variable "local_account" {
  default = "465369119046"
}

variable "sandstorm_core_account" {
  default = "734326455073"
}
