resource "aws_iam_role" "app" {
  name = "${var.iam_role_name}-${var.environment}-asg"
  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "ec2.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

resource "aws_iam_role_policy" "policy" {
  name = "${var.iam_role_name}-policy"
  role = "${var.iam_role_name}-${var.environment}-asg"
  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": "sts:AssumeRole",
      "Resource": [
      "arn:aws:iam::${var.local_account}:role/${var.iam_role_name}-${var.environment}",
      "arn:aws:iam::${var.sandstorm_core_account}:role/sandstorm/production/templated/role/${var.iam_role_name}-${var.environment}"
      ]
    }
  ]
}
EOF
}

resource "aws_iam_instance_profile" "app" {
  name = "${var.iam_role_name}-${var.environment}-asg"
  roles = ["${aws_iam_role.app.name}"]
}
